#COMPILE EXE
' constants

%idnum = 100001069 ' serial # of first LabJack

'===============================================================================
' DLL Declares

'===============================================================================
DECLARE FUNCTION LocalID SDECL LIB "ljackuw.dll" ALIAS "LocalID" ( _
    BYREF idnum AS LONG, BYVAL localID AS LONG) AS LONG

'======================================================================

DECLARE FUNCTION AOUpdate SDECL LIB "ljackuw.dll" ALIAS "AOUpdate" ( _
    BYREF lpIDNum AS LONG, _
    BYVAL lngDemo AS LONG, _
    BYVAL lngTrisD AS LONG, _
    BYVAL lngTrisIO AS LONG, _
    BYREF lpStateD AS LONG, _
    BYREF lpStateIO AS LONG, _
    BYVAL lngUpdateDigital AS LONG, _
    BYVAL lngResetCounter AS LONG, _
    BYREF lngCount AS LONG, _
    BYVAL sngAnalogOut0 AS SINGLE, _
    BYVAL sngAnalogOut1 AS SINGLE) AS LONG

'======================================================================
' AOUpdate: Sets the voltages of the analog outputs.  Also
'           controls/reads the digital IO and counter.
'
'  Returns:    LabJack errorcodes or 0 for no error (I32).
'  Inputs:     *idnum      -Local ID, Serial Number, or -1 for first
'                           found (I32).
'              demo        -Send 0 for normal operation, >0 for demo
'                           mode (I32).  Demo mode allows this function
'                           to be called without a LabJack, and does little
'                           but simulate execution time.
'              trisD       -Directions for D0-D16.  0=Input, 1=Output (I32).
'              trisIO      -Directions for IO0-IO3.  0=Input, 1=Output (I32).
'              *stateD         -Output states for D0-D16 (I32).
'              *stateIO    -Output states for IO0-IO3 (I32).
'              updateDigital   -If >0, tris and state values will be written.
'                               Otherwise, just a read is performed (I32).
'              resetCounter    -If >0, the counter is reset to zero after
'                               being read (I32).
'              analogOut0  -Voltage from 0 to 5 for AO0 (SGL).
'              analogOut1  -Voltage from 0 to 5 for AO1 (SGL).
'  Outputs:    *idnum      -Returns the Local ID or -1 if no LabJack is
'                           found (I32).
'              *stateD         -States of D0-D15 (I32).
'              *stateIO    -States of IO0-IO3 (I32).
'              *count      -Current count, before reset (U32).
'
'  Time:       20 ms
'======================================================================


DECLARE FUNCTION AISample SDECL LIB "ljackuw.dll" ALIAS "AISample" ( _
  BYREF idnum AS LONG, _
  BYVAL demo AS LONG, _
  BYREF stateIO AS LONG, _
  BYVAL updateIO AS LONG, _
  BYVAL ledOn AS LONG, _
  BYVAL numChannels AS LONG, _
  BYREF lpChannels AS LONG, _
  BYREF lpGains AS LONG, _
  BYVAL disableCal AS LONG, _
  BYREF overVoltage AS LONG, _
  BYREF lpVoltages AS SINGLE) AS LONG
'======================================================================

' Parameter Description:
'Returns:    LabJack errorcodes or 0 for no error.
'Inputs:
'   *idnum - Local ID, serial number, or -1 for first found.
'   demo - Send 0 for normal operation, >0 for demo mode.  Demo mode allows this function to be called without a LabJack.
'   *stateIO - Output states for IO0-IO3.
'   updateIO - If >0, state values will be written.  Otherwise, just a read is performed.
'   ledOn - If >0, the LabJack LED is turned on.
'   numChannels - Number of analog input channels to read (1,2, or 4).
'   *channels - Pointer to an array of channel commands with at least numChannels elements.  Each channel command is 0-7 for single-ended, or 8-11 for differential.
'   *gains - Pointer to an array of gain commands with at least numChannels elements.  Gain commands are 0=1, 1=2, , 7=20.  This amplification is only available for differential channels.
'   disableCal - If >0, voltages returned will be raw readings that are not corrected using calibration constants.
'   *voltages - Pointer to an array where voltage readings are returned.  Send a 4-element array of zeros.
'Outputs:
'   *idnum - Returns the local ID or -1 if no LabJack is found.
'   *overVoltage - If >0, an overvoltage has been detected on one of the selected analog inputs.
'   *voltages - Pointer to an array where numChannels voltage readings are returned.
'
'======================================================================

DECLARE FUNCTION GetFirmwareVersion LIB "ljackuw.dll" ALIAS "GetFirmwareVersion" ( _
  BYREF idnum AS LONG) AS SINGLE
'======================================================================


'===============================================================================
'Declare local functions

'===============================================================================
DECLARE FUNCTION up_date(_
    BYVAL TrisD_IO AS LONG, _
    BYVAL Tris_IO AS LONG, _
    BYREF DIG_State_D AS LONG, _
    BYREF DIG_State_IO AS LONG, _
    BYVAL UpdateDigital AS LONG, _
    BYVAL ResetCounter AS LONG, _
    BYREF Count AS LONG, _
    BYVAL AnalogOut0 AS SINGLE, _
    BYVAL AnalogOut1 AS SINGLE) AS LONG



DECLARE FUNCTION get_voltages(_
volts_1 AS SINGLE, _
volts_2 AS SINGLE,_
volts_3 AS SINGLE,_
volts_4 AS SINGLE) AS LONG


'===============================================================================
'Declare Global Vars

'===============================================================================

GLOBAL volts_1 AS SINGLE
GLOBAL volts_2 AS SINGLE
GLOBAL volts_3 AS SINGLE
GLOBAL volts_4 AS SINGLE
GLOBAL errorcode AS LONG

GLOBAL TrisD_IO AS LONG
GLOBAL Tris_IO AS LONG
GLOBAL DIG_State_D AS LONG
GLOBAL DIG_State_IO AS LONG
GLOBAL UpdateDigital AS LONG
GLOBAL ResetCounter AS LONG
GLOBAL Count AS LONG
GLOBAL AnalogOut0 AS SINGLE
GLOBAL AnalogOut1 AS SINGLE

'===============================================================================
' Start Main
'===============================================================================

FUNCTION PBMAIN () AS LONG


DIM idcode AS SINGLE
DIM update_error AS LONG
' check on DAQ if we get a firmware num its on and functioning
' idnum is set as a constant with serial #
idcode = GetFirmwareVersion( %idnum)
PRINT "nAIFirmware " , idcode
PRINT "nLocal ID  ",%idnum
PRINT

' currently only 4 of the I/O are set or read

DIM chkRead0 AS LONG
DIM chkRead1 AS LONG
DIM chkRead2 AS LONG
DIM chkRead3 AS LONG

DIM chkTris0 AS LONG
DIM chkTris1 AS LONG
DIM chkTris2 AS LONG
DIM chkTris3 AS LONG
DIM chkset0 AS LONG
DIM chkset1 AS LONG
DIM chkset2 AS LONG
DIM chkset3 AS LONG
DIM hWriteFile AS LONG

' Set ChkTris to Input or Output (0 / 1)
' Set Chkset to Off or On (0 / 1)

chkTris0 =1 'sets D0 Output
chkset0  =1 'sets D0 On


    UpdateDigital = 1
    ResetCounter = 0
    ' Sets A0 to 3.654 volts
    AnalogOut0 = 3.654
    AnalogOut1 = 0

    TrisD_IO = chkTris0 + (chkTris1 * (2 ^ 1)) + (chkTris2 * (2 ^ 2)) + (chkTris3 * (2 ^ 3))
    DIG_State_D = chkSet0 + (chkSet1 * (2 ^ 1)) + (chkSet2 * (2 ^ 2)) + (chkSet3 * (2 ^ 3))


update_error = up_date(TrisD_IO ,Tris_IO ,DIG_State_D ,DIG_State_IO , _
    UpdateDigital,ResetCounter ,Count ,AnalogOut0,AnalogOut1 )

    chkRead0 = DIG_State_D MOD 2
    DIG_State_D = DIG_State_D \ 2
    chkRead1 = DIG_State_D MOD 2
    DIG_State_D = DIG_State_D \ 2
    chkRead2 = DIG_State_D MOD 2
    DIG_State_D = DIG_State_D \ 2
    chkRead3 = DIG_State_D MOD 2
'===============================================================================
' All the above is to control or read the Digital I/O and Analog output.
'===============================================================================
hWriteFile = FREEFILE
OPEN "Temp_out.txt" FOR APPEND AS #hWriteFile
PRINT #hWriteFile, "Start Log"
DO

errorcode =  get_voltages(volts_1,volts_2,volts_3,volts_4)

volts_1  = (volts_1 - .5) * 100
volts_2 = (volts_2 - .5) * 100

volts_1s$ = STR$(volts_1 ,4)
volts_2s$ = STR$(volts_2 ,4)

IF hWriteFile THEN PRINT #hWriteFile, volts_1s$; ","; volts_2s$


PRINT "AI0  ",volts_1s$
PRINT "AI1  ",volts_2s$

'PRINT "AI2  ",volts_3
'PRINT "AI3  ",volts_4

PRINT
PRINT

SLEEP  60000



       ' Handle data from the keyboard.
        IF INSTAT THEN
            kData$ = INKEY$
            IF kData$ = $ESC THEN
                EXIT DO
            END IF
        END IF

LOOP



CLOSE #hWriteFile

END FUNCTION



'End Main

'===============================================================================
FUNCTION get_voltages(volts_1 AS SINGLE,volts_2 AS SINGLE,volts_3 AS SINGLE,volts_4 AS SINGLE)_
 AS LONG

DIM errorcode AS LONG
DIM idcode AS SINGLE
DIM demo AS LONG
DIM stateIO AS LONG
DIM updateIO AS LONG
DIM ledOn AS LONG
DIM numChannels AS LONG
DIM disableCal AS LONG
DIM ov AS LONG


DIM channels(4) AS LONG
DIM gains(4) AS LONG
DIM voltages(4) AS SINGLE

' serial of first labjack
demo=0
stateIO=0
updateIO = 0
ledon = 0
numChannels=4
disableCal = 0

' load channel info in channel array
FOR y& = 0 TO 3
 channels(y&) = y&
NEXT y&

CALL  AISample (%idnum,demo,stateIO,0,1,numChannels,channels(0),gains(0),0,ov,voltages(0)) TO errorcode

FUNCTION = errorcode
volts_1 = voltages(0)
volts_2 = voltages(1)
volts_3 = voltages(2)
volts_4 = voltages(3)

' clear arrays to zero's

RESET  gains()
RESET  voltages()


END FUNCTION

'===============================================================================

FUNCTION up_date(_
    BYVAL TrisD_IO AS LONG, _
    BYVAL Tris_IO AS LONG, _
    BYREF Dig_State_D AS LONG, _
    BYREF Dig_State_IO AS LONG, _
    BYVAL UpdateDigital AS LONG, _
    BYVAL ResetCounter AS LONG, _
    BYREF Count AS LONG, _
    BYVAL AnalogOut0 AS SINGLE, _
    BYVAL AnalogOut1 AS SINGLE) AS LONG


    DIM lngErrorcode AS LONG
    DIM IDNum AS LONG
    DIM demo  AS LONG


    Demo = 0


    lngErrorcode = AOUpdate(%IDNum,Demo,TrisD_IO,Tris_IO,DIG_State_D,DIG_State_IO,UpdateDigital,_
         ResetCounter,Count,AnalogOut0,AnalogOut1)



END FUNCTION

